IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CP_Recibo_Egreso_Banking]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[CP_Recibo_Egreso_Banking] 
END

GO
CREATE PROCEDURE [dbo].[CP_Recibo_Egreso_Banking]   @Id_Cliente INT,
                                                    @Id_Producto CHAR(14) , 
													@Id_Tipo_Cbte Varchar(5),
													@Importe Decimal(12,2),
													@Id_Trans INT,
													@lote Varchar(20),
													@Id_Cta_Banco INT
AS

/*Variables */
DECLARE @Id_Trans_New       INT;
DECLARE @fecha 				DATETIME;
DECLARE @Comprobante_nro 	INT;
DECLARE @id_sucursal 		SMALLINT;
DECLARE @id_iva 			CHAR(3);
DECLARE @cuit 				VARCHAR(19);
DECLARE @id_moneda 			CHAR(3);
DECLARE @Id_Familia         INT;
DECLARE @descripcion		CHAR(100);
DECLARE @id_cond_pago		SMALLINT;		
DECLARE @id_localidad 		SMALLINT;
DECLARE @id_provincia 		CHAR(3);
DECLARE @Destinatario		VARCHAR(100);
DECLARE @imp_neto 			DECIMAL(12,2);
DECLARE @imp_gravado 		DECIMAL(12,2);
DECLARE @imp_exento 		DECIMAL(12,2);
DECLARE @imp_iva 			DECIMAL(12,2);
DECLARE @imp_iva2 			DECIMAL(12,2);
DECLARE @imp_iva3 			DECIMAL(12,2);
DECLARE @imp_percepcion_iva DECIMAL(12,2);
DECLARE @imp_percepcion_IB 	DECIMAL(12,2);
DECLARE @imp_percep 		DECIMAL(12,2);
DECLARE @imp_total  		DECIMAL(12,2);
DECLARE @Id_Cond_Vta	    CHAR(10);	
DECLARE @Obs				VARCHAR(5000);
DECLARE @Descripcion_Producto VARCHAR(100);
DECLARE @cant				INT,@id_lista SMALLINT;
DECLARE @Email				VARCHAR(2000)
DECLARE @Fecha_Venc			DATE , @Fecha_QA DATE;
DECLARE @Id_Cliente_Cbte	INT
DECLARE @Id_Acti_Cbte		CHAR(14)
DECLARE @Mensaje			VARCHAR(100)

/*FIN Variables */


BEGIN TRY
--BEGIN TRAN

BEGIN
  
    Select * into #Nuevo from Cbtes where id_trans = @id_trans

    SET @fecha = (SELECT FECHA FROM CBTES WHERE id_trans = @id_trans)
 


    /*Busco proxima transaccin y agrego registro */
	SET @Id_Trans_New = (SELECT (MAX(Id_trans)+1) FROM Transacciones)

	INSERT INTO Transacciones
	(Id_Trans, Descripcion, Fecha_Mov,
	Id_Usuario)
	VALUES
	(@Id_Trans_New, @descripcion, @fecha,
	0/*Usuario*/)
	/*FIN Inserto Tabla: Transacciones*/

	/*Configuro otras Variables*/

	SET @Descripcion_Producto = (SELECT RTRIM(Descripcion_Resumida) FROM Productos WHERE Id_Producto=@Id_Producto)

	SET @Descripcion_Producto =   RTRIM(@Descripcion_Producto) + '  ' + (SELECT RTRIM(ID_TIPO_CBTE)  +' Nro: '+ RTRIM(Comprobante_Nro) FROM CBTES WHERE ID_TRANS = @ID_TRANS)
 
	SET @cuit = (SELECT cuit FROM clientes WHERE id_cliente=@id_cliente);
	SET @imp_total = @Importe;
	SET @Cant = 1;
	SET @imp_gravado = @imp_total;
	SET @imp_exento = 0;
	SET @imp_iva = 0;
	SET @imp_iva2 = 0;
	SET @imp_iva3 = 0;
	SET @imp_percepcion_iva = 0;
	SET @imp_percepcion_IB = 0;
	SET @imp_percep = 0;
	SET @Obs = ''
	SET @lote = ''

	/*FIN Configuro otras Variables*/

	/*MODIFICAR_E COMIENZO INSERTAR*/
	
	/*Inserto Tabla: CBTES*/
	Update #Nuevo set Id_trans        = @Id_Trans_New, 
	                  id_tipo_cbte    = @Id_tipo_Cbte, 
             	      Imp_Gravado     = ABS(@Importe),
					  Imp_Total       = ABS(@Importe),
					  Id_Moneda       = 'PES',
					  Cotizacion      = 1,
					  Saldo           = 0,
					  Porc_Iva        = 0,
					  Porc_Iva2       = 0,
					  Porc_Iva3       = 0,
					  Saldo_Iva_Recup = 0,
					  Id_Estado_Cbte  = 2
         

	INSERT INTO Cbtes
	       SELECT * FROM #Nuevo
    set @imp_total = @imp_total*-1
	INSERT INTO Cbtes_Items	(id_cliente,		descripcion_producto,		Cantidad,
							id_estado_Cbte,		Cantidad_Saldo,				Id_Trans,
							item,				Precio_Grav,				Imp_Gravado,
							Imp_Final,			Precio,						Lote,
							Fecha_QA,			Flag_QA,					Id_Producto,
							Fecha_Venc,         Id_Cta_Banco )
	VALUES					(@id_cliente,		RTRIM(@Descripcion_Producto),@Cant,
							2,	                @Cant,	            		@id_trans_New,
							1,					@imp_total,					@imp_total,
							@imp_total,	    	@imp_total,					@Lote,
							@fecha,				'A',			     		@Id_Producto,
							@fecha,             @Id_Cta_Banco)

    SET @Mensaje = 'Trans. Agregada ' + CAST(@Id_Trans as VARCHAR(14))

    /*Inserto Tabla: CBTES_APLICA */
	    Select * into #Nuevo_APLICA from Cbtes_APLICA where id_trans_D = @id_trans AND ITEM = 1

		UPDATE #Nuevo_APLICA SET Id_trans = @id_trans_New, ITEM = 2

		INSERT INTO CBTES_APLICA 
		       SELECT * FROM #Nuevo_APLICA

        
		DROP TABLE #Nuevo_APLICA
        DROP TABLE #Nuevo
END

--COMMIT

SELECT 0,0,0,0,0,@Mensaje

END TRY  
BEGIN CATCH  
    -- Execute error retrieval routine.  
    EXECUTE usp_GetErrorInfo;  
--	ROLLBACK
END CATCH;   






 
